; Starpath by HellMood/DSR
; 64 byte intro for MSDOS
; 1st place at "Lovebyte 2025"
;
; heaven is one step around the corner
; ... you just have to keep moving
;
; greetings to all sizecoders !

;
;           "starpure"
;

; this is the PURE ** 57 bytes ** version
; for all REAL hardware out there
; it lacks sound or ESC support
; is not synced against a timer
; star pattern is just okay
; and has no dithering to smoothen
; but is only ** 57 ** bytes, so you
; can customize your own starpath =)

push 0xa000			; let ES point to 0xA000
pop es				; start of VGA Video RAM
mov al,0x13			; mode 13h, 320x200 pixels, 256 colors
int 10h				; set graphic mode
X: mov bl,14		; start depth at 14
L: mov ax,0xcccd	; Rrrola constant
mul di				; Getting X,Y in DL,DH
mov al,dh			; getting Y into AL
mul bl				; multiply Y by current depth (into AH)
xchg ax,dx			; store Y' into DH, get X into AL
sub al,bl			; curve X by the current depth
jc W				; if left of the curve, jump to "sky"
mul bl				; multiply X by current depth (into AH)
mov al,dh			; get Y' in AL (now AL,AH = Y',X')
or al,ah			; OR for geometry and texture pattern
lea dx,[bx+si]		; get (current depth) + (current frame count) in DX (DL)
and al,dl			; mask geometry/texture by time shifted depth...
inc bx				; (increment depth by one)
test al,16			; ... to create "gaps"
jz L				; if ray did not hit, repeat pixel loop
jmp short Q			; jump over the sky ^^
W: mov al,27		; is both the star color and palette offset into sky
cmp cl,dl			; pseudorandom multiplication leftover DL added
jz Q				; to shifted depth, 1 in 256 chance to be a star *
shld ax,di,4		; if not, shift the starcolor and add scaled pixel count
Q: stosb			; write pixel to RAM, advance pixel counter
loop X				; repeat for 64k pixels
inc si				; increment frame counter
jmp short X			; rinse and repeat